/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.security.engine.core;

import digital.nedra.commons.starter.security.engine.utils.SecurityUtils;
import java.util.List;
import java.util.Optional;

/**
 * Получение роли пользователя.
 */
public interface RoleResolver {

  /**
   * Получение роли пользователя.
   *
   * @return Роль пользователя
   */
  default List<String> getRoles() {
    return getUserOid()
        .map(this::getRoles)
        .orElseGet(this::getDefaultRoles);
  }

  /**
   * Получение роли пользователя по ID.
   *
   * @param userId Id Пользователя
   * @return Роль пользователя {@link String}
   */
  List<String> getRoles(String userId);

  /**
   * Получение дефолтной роли пользователя.
   *
   * @return Роль пользователя по умолчанию {@link String}
   */
  List<String> getDefaultRoles();

  /**
   * Получение id пользователя.
   *
   * @return id пользователя
   */
  default Optional<String> getUserOid() {
    return SecurityUtils.getUserOid();
  }

}
