/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.engine.core;

import digital.nedra.commons.starter.security.engine.core.Authority;
import digital.nedra.commons.starter.security.engine.core.AuthorityConfigurer;
import digital.nedra.commons.starter.security.engine.core.ContextConfigure;
import digital.nedra.commons.starter.security.engine.core.RoleHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;

public interface RoleBuilder {
    public RoleBuilder role(String var1);

    public ContextConfigure authority(String var1);

    public RoleBuilder and();

    public RoleBuilder handler(BiPredicate<String, Object> var1);

    public RoleHandler build();

    public static class DefaultRoleBuilder
    implements RoleBuilder {
        private String role;
        private List<Authority> authorities;
        private BiPredicate<String, Object> handler;
        AuthorityConfigurer.DefaultAuthorityConfigurer conf;

        @Override
        public RoleHandler.DefaultRoleHandler build() {
            Objects.requireNonNull(this.role, "Role is not set");
            Objects.requireNonNull(this.authorities, "Authorities are not set");
            return new RoleHandler.DefaultRoleHandler(this.role, this.authorities, this.handler);
        }

        @Override
        public RoleBuilder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public ContextConfigure authority(String authority) {
            this.conf = new AuthorityConfigurer.DefaultAuthorityConfigurer();
            this.conf.setName(authority);
            this.conf.setParent(this);
            return this.conf.context();
        }

        @Override
        public RoleBuilder and() {
            if (this.authorities == null) {
                this.authorities = new ArrayList<Authority>();
            }
            if (this.conf != null) {
                this.authorities.add(Authority.builder().name(this.conf.getName()).available(this.conf.isAvailable()).context(this.conf.getFields()).build());
            }
            return this;
        }

        @Override
        public RoleBuilder handler(BiPredicate<String, Object> func) {
            this.handler = func;
            return this;
        }

        public String toString() {
            return "RoleBuilder.DefaultRoleBuilder(role=" + this.role + ", authorities=" + this.authorities + ", handler=" + this.handler + ", conf=" + this.conf + ")";
        }
    }
}

