/*
 * Copyright 2023 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.security.config;

import java.util.List;
import lombok.NonNull;
import lombok.experimental.UtilityClass;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@UtilityClass
public class RequestMatcherUtil {
  @NonNull
  public static OrRequestMatcher toRequestMatcher(
      List<? extends MatchersConfiguration> matchersConfigurations
  ) {
    List<RequestMatcher> requestMatchers = matchersConfigurations.stream()
        .flatMap(i -> i.getAntMatchers().stream())
        .<RequestMatcher>map(AntPathRequestMatcher::new)
        .toList();
    return new OrRequestMatcher(requestMatchers);
  }
}
