/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.security.config;

import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

class AbstractMatchersConfig {

  @Bean
  @ConditionalOnBean(BasicMatchersConfiguration.class)
  public Customizer<ExpressionUrlAuthorizationConfigurer<HttpSecurity>
      .ExpressionInterceptUrlRegistry> basicAuthorizeRequestsCustomizer(
      List<BasicMatchersConfiguration> matchersConfigurations) {
    return (requests) -> matchersConfigurations.forEach(matchersConfiguration ->
        requests
            .requestMatchers(matchersConfiguration.getAntMatchers().toArray(String[]::new))
            .access(matchersConfiguration.getSpelExp())
    );
  }
}