package digital.nedra.commons.starter.security.config;

import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import lombok.experimental.UtilityClass;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@UtilityClass
public class RequestMatcherUtil {
  @NonNull
  public static OrRequestMatcher toRequestMatcher(
      List<? extends MatchersConfiguration> matchersConfigurations
  ) {
    List<RequestMatcher> requestMatchers = matchersConfigurations.stream()
        .flatMap(i -> i.getAntMatchers().stream())
        .map(AntPathRequestMatcher::new)
        .collect(Collectors.toList());
    return new OrRequestMatcher(requestMatchers);
  }
}
