/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.security.conditional;

import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;

public class AnySecurityStarter extends AnyNestedCondition {

  public AnySecurityStarter() {
    super(ConfigurationPhase.REGISTER_BEAN);
  }

  @ConditionalOnClass(
      name = "digital.nedra.commons.starter.security.oauth2.bearer.OAuth2StarterAutoConfiguration")
  static class OnBearerSecurityStarter {
  }

  @ConditionalOnClass(
      name = "digital.nedra.commons.starter.keycloak.session.KeycloakAutoConfiguration")
  static class OnKeycloakSessionSecurityStarter {
  }

}
