/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.security.config;

import static digital.nedra.commons.starter.security.utils.Constants.API_PREFIX;

import digital.nedra.commons.starter.security.conditional.AnySecurityStarter;
import java.util.ArrayList;
import java.util.List;
import lombok.RequiredArgsConstructor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Conditional(AnySecurityStarter.class)
@Configuration
@RequiredArgsConstructor
public class DefaultSecurityMatchersConfig extends AbstractMatchersConfig {
  @Bean
  public MatchersConfiguration publicMatchers() {
    List<String> antMatchers = new ArrayList<>();
    antMatchers.add(API_PREFIX + "/uaa/json");
    antMatchers.add(API_PREFIX + "/uaa/me");
    String accessAttribute = "permitAll";
    return new MatchersConfiguration(antMatchers, accessAttribute);
  }
}
