/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.security.config;

import digital.nedra.commons.starter.security.utils.Constants;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

public abstract class AbstractMatchersConfig {

  @Bean
  public MatchersConfiguration apiMatchers() {
    List<String> antMatchers = new ArrayList<>();
    antMatchers.add(Constants.API_PREFIX + "/**");
    String accessAttribute = "authenticated";
    return new MatchersConfiguration(antMatchers, accessAttribute);
  }

  @Bean
  public Customizer<ExpressionUrlAuthorizationConfigurer<HttpSecurity>
      .ExpressionInterceptUrlRegistry> authorizeRequestsCustomizer(
      List<MatchersConfiguration> matchersConfigurations) {
    return (requests) -> {
      matchersConfigurations.forEach(matchersConfiguration ->
          requests
              .antMatchers(matchersConfiguration.getAntMatchers().toArray(String[]::new))
              .access(matchersConfiguration.getSpelExp())
      );
    };
  }
}
