/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.service;

import digital.nedra.commons.starter.common.config.properties.OAuth2Properties;
import digital.nedra.commons.starter.security.dto.OidcConfigurationDto;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@ConditionalOnClass(name={"digital.nedra.commons.starter.security.oauth2.bearer.OAuth2StarterAutoConfiguration"})
@Service
public class OidcConfigurationResolver {
    private final RestTemplateBuilder restTemplateBuilder;
    private final Optional<OidcConfigurationDto> oidcConfiguration;

    public OidcConfigurationResolver(RestTemplateBuilder restTemplateBuilder, OAuth2Properties commonProperties) {
        this.restTemplateBuilder = restTemplateBuilder;
        this.oidcConfiguration = Optional.ofNullable(commonProperties.getIssuerUri()).map(this::resolve);
    }

    public Optional<OidcConfigurationDto> getOidcConfiguration() {
        return this.oidcConfiguration;
    }

    private OidcConfigurationDto resolve(String issuer) {
        RestTemplate rest = this.restTemplateBuilder.build();
        return (OidcConfigurationDto)rest.getForObject(issuer + "/.well-known/openid-configuration", OidcConfigurationDto.class, new Object[0]);
    }
}

