/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.config;

import digital.nedra.commons.starter.common.config.properties.SecurityProperties;
import digital.nedra.commons.starter.security.conditional.AnySecurityStarter;
import digital.nedra.commons.starter.security.config.AbstractMatchersConfig;
import digital.nedra.commons.starter.security.config.SessionMatchersConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.access.expression.WebExpressionAuthorizationManager;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Conditional(value={AnySecurityStarter.class})
@Configuration
public class SecurityMatchersConfig
extends AbstractMatchersConfig {
    private final SecurityProperties securityProperties;

    @Bean
    @Order(value=100)
    public SessionMatchersConfiguration apiMatchers() {
        ArrayList<String> antMatchers = new ArrayList<String>();
        antMatchers.add("/api/**");
        String accessAttribute = "authenticated";
        return new SessionMatchersConfiguration(antMatchers, accessAttribute);
    }

    @Bean
    @Order(value=10)
    public SessionMatchersConfiguration sessionPublicMatchers() {
        ArrayList<String> antMatchers = new ArrayList<String>();
        antMatchers.add("/api/uaa/json");
        antMatchers.add("/api/uaa/me");
        antMatchers.addAll(this.securityProperties.getIgnoredUrls());
        String accessAttribute = "permitAll";
        return new SessionMatchersConfiguration(antMatchers, accessAttribute);
    }

    @Bean
    public Customizer<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry> sessionAuthorizeRequestsCustomizer(List<SessionMatchersConfiguration> matchersConfigurations) {
        return requests -> matchersConfigurations.forEach(matchersConfiguration -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers((RequestMatcher[])matchersConfiguration.getAntMatchers().stream().map(AntPathRequestMatcher::antMatcher).toArray(RequestMatcher[]::new))).access((AuthorizationManager)new WebExpressionAuthorizationManager(matchersConfiguration.getSpelExp())));
    }

    public SecurityMatchersConfig(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }
}

