/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.config.support;

import digital.nedra.commons.starter.keycloak.session.exception.UnsupportedRedirectModeException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
@Order(value=-2147483648)
public class XhrRedirectFilter
extends OncePerRequestFilter {
    public static final String XML_HTTP_REQUEST = "XMLHttpRequest";
    public static final String X_REQUESTED_WITH = "X-Requested-With";
    public static final String ACCESS_DENIED = "Access Denied";
    @Value(value="${starters.keycloak.redirect-mode}")
    private String redirectMode;
    @Value(value="${starters.keycloak.url-holder-header}")
    private String urlHolderHeader;

    protected void doFilterInternal(final HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filterChain.doFilter((ServletRequest)request, (ServletResponse)new HttpServletResponseWrapper(response){

            public void sendRedirect(String location) throws IOException {
                if (RedirectMode.ALWAYS_REDIRECT.name().equals(XhrRedirectFilter.this.redirectMode)) {
                    super.sendRedirect(location);
                } else if (RedirectMode.HEADER_BASED.name().equals(XhrRedirectFilter.this.redirectMode)) {
                    if (XhrRedirectFilter.XML_HTTP_REQUEST.equals(request.getHeader(XhrRedirectFilter.X_REQUESTED_WITH))) {
                        this.sendXhrRedirect(location);
                    } else {
                        super.sendRedirect(location);
                    }
                } else {
                    throw new UnsupportedRedirectModeException(XhrRedirectFilter.this.redirectMode);
                }
            }

            private void sendXhrRedirect(String location) throws IOException {
                super.setHeader(XhrRedirectFilter.this.urlHolderHeader, location);
                super.sendError(401, XhrRedirectFilter.ACCESS_DENIED);
            }
        });
    }

    public static enum RedirectMode {
        ALWAYS_REDIRECT,
        HEADER_BASED;

    }
}

