/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.config.support;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class KeycloakLogoutHandler
extends SecurityContextLogoutHandler {
    private static final Logger log = LoggerFactory.getLogger(KeycloakLogoutHandler.class);
    private final RestTemplate restTemplate = new RestTemplate();
    @Value(value="${starters.keycloak.protocol-url}")
    private String protocolUrl;

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        super.logout(request, response, authentication);
        if (authentication == null) {
            log.info("The user has already logged out");
            return;
        }
        OidcUser user = (OidcUser)authentication.getPrincipal();
        String endSessionEndpoint = this.protocolUrl + "/logout";
        UriComponentsBuilder builder = UriComponentsBuilder.fromUriString((String)endSessionEndpoint).queryParam("id_token_hint", new Object[]{user.getIdToken().getTokenValue()});
        ResponseEntity logoutResponse = this.restTemplate.getForEntity(builder.toUriString(), String.class, new Object[0]);
        if (logoutResponse.getStatusCode().is2xxSuccessful()) {
            log.info("Successfully logged out in Keycloak");
        } else {
            log.info("Could not propagate logout to Keycloak");
        }
    }
}

