/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.config;

import digital.nedra.commons.starter.keycloak.session.config.support.KeycloakLogoutHandler;
import digital.nedra.commons.starter.keycloak.session.config.support.KeycloakOauth2UserService;
import digital.nedra.commons.starter.keycloak.session.config.support.XhrCookieRequestCache;
import digital.nedra.commons.starter.security.config.BasicMatchersConfiguration;
import digital.nedra.commons.starter.security.config.RequestMatcherUtil;
import digital.nedra.commons.starter.security.config.SessionMatchersConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
public class SecurityConfigurerAdapter {
    private final KeycloakLogoutHandler logoutHandler;
    private final XhrCookieRequestCache requestCache;
    private final KeycloakOauth2UserService keycloakOidcUserService;
    private final Customizer<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry> sessionAuthorizeRequestsCustomizer;
    private final Customizer<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry> basicAuthorizeRequestsCustomizer;
    @Value(value="${spring.security.oauth2.client.registration.sso.provider}")
    private String oauth2Provider;
    @Autowired(required=false)
    private Customizer<ExceptionHandlingConfigurer<HttpSecurity>> exceptionHandlingCustomizer;
    private final List<BasicMatchersConfiguration> basicMatchersConfigurations;
    private final List<SessionMatchersConfiguration> sessionMatchersConfigurations;

    @Bean
    @Order(value=10)
    @ConditionalOnBean(value={BasicMatchersConfiguration.class})
    public SecurityFilterChain basicFilterChain(HttpSecurity http) throws Exception {
        if (Objects.nonNull(this.exceptionHandlingCustomizer)) {
            http.exceptionHandling(this.exceptionHandlingCustomizer);
        }
        return (SecurityFilterChain)http.csrf(AbstractHttpConfigurer::disable).securityMatcher((RequestMatcher)RequestMatcherUtil.toRequestMatcher(this.basicMatchersConfigurations)).authorizeHttpRequests(this.basicAuthorizeRequestsCustomizer).httpBasic(Customizer.withDefaults()).build();
    }

    @Bean
    @Order(value=30)
    @ConditionalOnBean(value={SessionMatchersConfiguration.class})
    public SecurityFilterChain sessionFilterChain(HttpSecurity http) throws Exception {
        if (Objects.nonNull(this.exceptionHandlingCustomizer)) {
            http.exceptionHandling(this.exceptionHandlingCustomizer);
        }
        ArrayList<SessionMatchersConfiguration> matchersConfigurations = new ArrayList<SessionMatchersConfiguration>(this.sessionMatchersConfigurations);
        matchersConfigurations.add(new SessionMatchersConfiguration(List.of("/oauth2/**", "/login/**"), null));
        return (SecurityFilterChain)http.securityMatcher((RequestMatcher)RequestMatcherUtil.toRequestMatcher(matchersConfigurations)).authorizeHttpRequests(this.sessionAuthorizeRequestsCustomizer).oauth2Login(oauth2Login -> oauth2Login.loginPage("/oauth2/authorization/" + this.oauth2Provider).userInfoEndpoint(userInfoEndpoint -> userInfoEndpoint.oidcUserService((OAuth2UserService)this.keycloakOidcUserService))).oauth2Client(Customizer.withDefaults()).logout(logout -> logout.addLogoutHandler((LogoutHandler)this.logoutHandler)).csrf(AbstractHttpConfigurer::disable).cors(Customizer.withDefaults()).requestCache(cache -> cache.requestCache((RequestCache)this.requestCache)).build();
    }

    public SecurityConfigurerAdapter(KeycloakLogoutHandler logoutHandler, XhrCookieRequestCache requestCache, KeycloakOauth2UserService keycloakOidcUserService, Customizer<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry> sessionAuthorizeRequestsCustomizer, Customizer<AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry> basicAuthorizeRequestsCustomizer, List<BasicMatchersConfiguration> basicMatchersConfigurations, List<SessionMatchersConfiguration> sessionMatchersConfigurations) {
        this.logoutHandler = logoutHandler;
        this.requestCache = requestCache;
        this.keycloakOidcUserService = keycloakOidcUserService;
        this.sessionAuthorizeRequestsCustomizer = sessionAuthorizeRequestsCustomizer;
        this.basicAuthorizeRequestsCustomizer = basicAuthorizeRequestsCustomizer;
        this.basicMatchersConfigurations = basicMatchersConfigurations;
        this.sessionMatchersConfigurations = sessionMatchersConfigurations;
    }
}

