/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.config;

import digital.nedra.commons.starter.security.config.SessionMatchersConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;

@Configuration
public class SecurityConfig {
    @Value(value="${spring.security.oauth2.client.registration.sso.provider}")
    private String oauth2Provider;

    @Bean
    public SessionMatchersConfiguration swaggerMatchers() {
        return new SessionMatchersConfiguration(List.of("/swagger-ui/**"), "authenticated");
    }

    @Bean
    public SessionMatchersConfiguration logoutMatcher() {
        return new SessionMatchersConfiguration(List.of("/logout"), "authenticated");
    }

    @Bean
    @ConditionalOnMissingBean(value={JwtDecoder.class})
    public JwtDecoder keycloakJwtDecoder(OAuth2ClientProperties oauth2ClientProperties) {
        return NimbusJwtDecoder.withJwkSetUri((String)((OAuth2ClientProperties.Provider)oauth2ClientProperties.getProvider().get(this.oauth2Provider)).getJwkSetUri()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={OAuth2AuthorizedClientService.class})
    public OAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository(OAuth2ClientProperties properties) {
        OAuth2ClientPropertiesMapper mapper = new OAuth2ClientPropertiesMapper(properties);
        ArrayList registrations = new ArrayList(mapper.asClientRegistrations().values());
        return new InMemoryClientRegistrationRepository(registrations);
    }
}

