/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.config.support;

import digital.nedra.commons.starter.keycloak.session.config.support.XhrRedirectFilter;
import java.util.Base64;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.web.savedrequest.CookieRequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.savedrequest.SimpleSavedRequest;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;

@Component
public class XhrCookieRequestCache
extends CookieRequestCache {
    @Value(value="${starters.keycloak.redirect-mode}")
    private String redirectMode;
    @Value(value="${starters.keycloak.redirect-url-header}")
    private String redirectUrlHeader;

    public SavedRequest getRequest(HttpServletRequest request, HttpServletResponse response) {
        return Optional.ofNullable(WebUtils.getCookie((HttpServletRequest)request, (String)"REDIRECT_URI")).map(Cookie::getValue).map(String::getBytes).map(i -> Base64.getDecoder().decode((byte[])i)).map(String::new).map(SimpleSavedRequest::new).orElse(null);
    }

    public void saveRequest(HttpServletRequest request, HttpServletResponse response) {
        if (!AnyRequestMatcher.INSTANCE.matches(request)) {
            this.logger.debug((Object)"Request not saved as configured RequestMatcher did not match");
            return;
        }
        String redirectUrl = this.getRedirectUrl(request);
        Cookie savedCookie = new Cookie("REDIRECT_URI", Base64.getEncoder().encodeToString(redirectUrl.getBytes()));
        savedCookie.setMaxAge(-1);
        savedCookie.setSecure(request.isSecure());
        String contextPath = request.getContextPath();
        String cookiePath = !StringUtils.isEmpty((Object)contextPath) ? contextPath : "/";
        savedCookie.setPath(cookiePath);
        savedCookie.setHttpOnly(true);
        response.addCookie(savedCookie);
    }

    private String getRedirectUrl(HttpServletRequest request) {
        if (XhrRedirectFilter.RedirectMode.ALWAYS_REDIRECT.name().equals(this.redirectMode)) {
            return UrlUtils.buildFullRequestUrl((HttpServletRequest)request);
        }
        if (XhrRedirectFilter.RedirectMode.HEADER_BASED.name().equals(this.redirectMode)) {
            if ("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))) {
                return Optional.ofNullable(request.getHeader(this.redirectUrlHeader)).orElseGet(() -> request.getHeader("Referer"));
            }
            return UrlUtils.buildFullRequestUrl((HttpServletRequest)request);
        }
        throw new RuntimeException("Unsupported redirect mode: " + this.redirectMode);
    }
}

