/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.config.support;

import digital.nedra.commons.starter.keycloak.session.config.support.KeycloakAuthoritiesExtractor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserService;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.oidc.user.DefaultOidcUser;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.stereotype.Component;

@Component
public class KeycloakOauth2UserService
extends OidcUserService {
    private static final Logger log = LoggerFactory.getLogger(KeycloakOauth2UserService.class);
    public static final String REALM_ACCESS = "realm_access";
    public static final String RESOURCE_ACCESS = "resource_access";
    private static final OAuth2Error INVALID_REQUEST = new OAuth2Error("invalid_request");
    private final JwtDecoder jwtDecoder;
    private final KeycloakAuthoritiesExtractor keycloakAuthoritiesExtractor;
    @Value(value="${spring.security.oauth2.client.provider.sso.user-name-attribute}")
    private String nameAttribute;

    public OidcUser loadUser(OidcUserRequest userRequest) throws OAuth2AuthenticationException {
        OidcUser user = super.loadUser(userRequest);
        Collection<GrantedAuthority> keycloakAuthorities = this.extractKeycloakAuthorities(userRequest);
        return this.withAuthorities(user, keycloakAuthorities);
    }

    private OidcUser withAuthorities(OidcUser user, Collection<? extends GrantedAuthority> authorities) {
        return new DefaultOidcUser(authorities, user.getIdToken(), user.getUserInfo(), this.nameAttribute);
    }

    private Collection<GrantedAuthority> extractKeycloakAuthorities(OidcUserRequest userRequest) {
        Jwt token = this.parseJwt(userRequest.getAccessToken().getTokenValue());
        String clientId = userRequest.getClientRegistration().getClientId();
        if (log.isTraceEnabled()) {
            log.trace("Client name: {}", (Object)clientId);
        }
        List clientAuthorities = Optional.ofNullable(token.getClaimAsMap(RESOURCE_ACCESS)).map(m -> this.keycloakAuthoritiesExtractor.extractClientAuthorities(clientId, (Map<String, Object>)m)).orElseGet(Collections::emptyList);
        List realmAuthorities = Optional.ofNullable(token.getClaimAsMap(REALM_ACCESS)).map(this.keycloakAuthoritiesExtractor::extractRealmAuthorities).orElseGet(Collections::emptyList);
        return Stream.concat(clientAuthorities.stream(), realmAuthorities.stream()).collect(Collectors.toUnmodifiableList());
    }

    private Jwt parseJwt(String accessTokenValue) {
        try {
            return this.jwtDecoder.decode(accessTokenValue);
        }
        catch (JwtException e) {
            throw new OAuth2AuthenticationException(INVALID_REQUEST, (Throwable)e);
        }
    }

    public KeycloakOauth2UserService(JwtDecoder jwtDecoder, KeycloakAuthoritiesExtractor keycloakAuthoritiesExtractor) {
        this.jwtDecoder = jwtDecoder;
        this.keycloakAuthoritiesExtractor = keycloakAuthoritiesExtractor;
    }
}

