/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.config.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.mapping.SimpleAuthorityMapper;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class KeycloakAuthoritiesExtractor {
    public static final String ROLES = "roles";
    private final SimpleAuthorityMapper authoritiesMapper = new SimpleAuthorityMapper();

    @PostConstruct
    public void init() {
        this.authoritiesMapper.setConvertToUpperCase(true);
    }

    public List<GrantedAuthority> extractRealmAuthorities(Map<String, Object> resourceMap) {
        List authorities = (List)resourceMap.get(ROLES);
        if (CollectionUtils.isEmpty((Collection)authorities)) {
            return Collections.emptyList();
        }
        return this.map(AuthorityUtils.createAuthorityList((String[])((String[])authorities.toArray(String[]::new))));
    }

    public List<GrantedAuthority> extractClientAuthorities(String clientId, Map<String, Object> resourceMap) {
        Map clientResource = (Map)resourceMap.get(clientId);
        if (CollectionUtils.isEmpty((Map)clientResource)) {
            return Collections.emptyList();
        }
        List clientRoles = (List)clientResource.get(ROLES);
        if (CollectionUtils.isEmpty((Collection)clientRoles)) {
            return Collections.emptyList();
        }
        return this.map(AuthorityUtils.createAuthorityList((String[])((String[])clientRoles.toArray(String[]::new))));
    }

    private List<GrantedAuthority> map(List<GrantedAuthority> authorities) {
        return new ArrayList<GrantedAuthority>(this.authoritiesMapper.mapAuthorities(authorities));
    }
}

