/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.security.config;

import digital.nedra.commons.starter.common.config.properties.SecurityProperties;
import digital.nedra.commons.starter.security.conditional.AnySecurityStarter;
import digital.nedra.commons.starter.security.config.AbstractMatchersConfig;
import digital.nedra.commons.starter.security.config.SessionMatchersConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;

@Conditional(value={AnySecurityStarter.class})
@Configuration
public class SecurityMatchersConfig
extends AbstractMatchersConfig {
    private final SecurityProperties securityProperties;

    @Bean
    @Order(value=100)
    public SessionMatchersConfiguration apiMatchers() {
        ArrayList<String> antMatchers = new ArrayList<String>();
        antMatchers.add("/api/**");
        String accessAttribute = "authenticated";
        return new SessionMatchersConfiguration(antMatchers, accessAttribute);
    }

    @Bean
    @Order(value=10)
    public SessionMatchersConfiguration sessionPublicMatchers() {
        ArrayList<String> antMatchers = new ArrayList<String>();
        antMatchers.add("/api/uaa/json");
        antMatchers.add("/api/uaa/me");
        antMatchers.addAll(this.securityProperties.getIgnoredUrls());
        String accessAttribute = "permitAll";
        return new SessionMatchersConfiguration(antMatchers, accessAttribute);
    }

    @Bean
    public Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> sessionAuthorizeRequestsCustomizer(List<SessionMatchersConfiguration> matchersConfigurations) {
        return requests -> matchersConfigurations.forEach(matchersConfiguration -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.antMatchers((String[])matchersConfiguration.getAntMatchers().toArray(String[]::new))).access(matchersConfiguration.getSpelExp()));
    }

    public SecurityMatchersConfig(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }
}

