/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.endpoint;

import java.util.Objects;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.AuthenticatedPrincipal;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/uaa"})
public class SecurityEndpoint {
    @GetMapping(value={"/me"})
    public ResponseEntity<String> me() {
        Object principal = Optional.ofNullable(SecurityContextHolder.getContext()).map(SecurityContext::getAuthentication).map(Authentication::getPrincipal).orElse(null);
        if (Objects.nonNull(principal)) {
            if (principal instanceof AuthenticatedPrincipal) {
                return ResponseEntity.ok((Object)((AuthenticatedPrincipal)principal).getName());
            }
            if (principal instanceof UserDetails) {
                return ResponseEntity.ok((Object)((UserDetails)principal).getUsername());
            }
        }
        return ResponseEntity.notFound().build();
    }
}

