/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.config;

import digital.nedra.commons.starter.common.config.properties.SecurityProperties;
import digital.nedra.commons.starter.keycloak.session.config.support.KeycloakLogoutHandler;
import digital.nedra.commons.starter.keycloak.session.config.support.KeycloakOauth2UserService;
import digital.nedra.commons.starter.keycloak.session.config.support.XhrCookieRequestCache;
import digital.nedra.commons.starter.security.config.BasicMatchersConfiguration;
import digital.nedra.commons.starter.security.config.RequestMatcherUtil;
import digital.nedra.commons.starter.security.config.SessionMatchersConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.ExceptionHandlingConfigurer;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.RequestMatcher;

@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
@Configuration
public class SecurityConfigurerAdapter {
    private final KeycloakLogoutHandler logoutHandler;
    private final XhrCookieRequestCache requestCache;
    private final KeycloakOauth2UserService keycloakOidcUserService;
    private final Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> sessionAuthorizeRequestsCustomizer;
    private final Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> basicAuthorizeRequestsCustomizer;
    private final SecurityProperties securityProperties;
    @Value(value="${spring.security.oauth2.client.registration.sso.provider}")
    private String oauth2Provider;
    @Autowired(required=false)
    private Customizer<ExceptionHandlingConfigurer<HttpSecurity>> exceptionHandlingCustomizer;
    private final List<BasicMatchersConfiguration> basicMatchersConfigurations;
    private final List<SessionMatchersConfiguration> sessionMatchersConfigurations;

    @Bean
    @Order(value=10)
    @ConditionalOnBean(value={BasicMatchersConfiguration.class})
    public SecurityFilterChain basicFilterChain(HttpSecurity http) throws Exception {
        if (Objects.nonNull(this.exceptionHandlingCustomizer)) {
            http.exceptionHandling(this.exceptionHandlingCustomizer);
        }
        http.requestMatcher((RequestMatcher)RequestMatcherUtil.toRequestMatcher(this.basicMatchersConfigurations)).authorizeRequests(this.basicAuthorizeRequestsCustomizer).httpBasic();
        return (SecurityFilterChain)http.build();
    }

    @Bean
    @Order(value=30)
    @ConditionalOnBean(value={SessionMatchersConfiguration.class})
    public SecurityFilterChain sessionFilterChain(HttpSecurity http) throws Exception {
        if (Objects.nonNull(this.exceptionHandlingCustomizer)) {
            http.exceptionHandling(this.exceptionHandlingCustomizer);
        }
        ArrayList<SessionMatchersConfiguration> matchersConfigurations = new ArrayList<SessionMatchersConfiguration>(this.sessionMatchersConfigurations);
        matchersConfigurations.add(new SessionMatchersConfiguration(List.of("/oauth2/**", "/login/**"), null));
        return (SecurityFilterChain)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.requestMatcher((RequestMatcher)RequestMatcherUtil.toRequestMatcher(matchersConfigurations)).authorizeRequests(this.sessionAuthorizeRequestsCustomizer).oauth2Login(httpSec -> httpSec.loginPage("/oauth2/authorization/" + this.oauth2Provider).userInfoEndpoint().oidcUserService((OAuth2UserService)this.keycloakOidcUserService)).oauth2Client().and()).logout().addLogoutHandler((LogoutHandler)this.logoutHandler).and()).csrf().disable()).cors().and()).requestCache(i -> i.requestCache((RequestCache)this.requestCache)).build();
    }

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        return web -> {
            WebSecurity.IgnoredRequestConfigurer ignoredRequestConfigurer = web.ignoring();
            this.securityProperties.getIgnoredUrls().forEach(xva$0 -> {
                WebSecurity.IgnoredRequestConfigurer cfr_ignored_0 = (WebSecurity.IgnoredRequestConfigurer)ignoredRequestConfigurer.antMatchers(new String[]{xva$0});
            });
        };
    }

    public SecurityConfigurerAdapter(KeycloakLogoutHandler logoutHandler, XhrCookieRequestCache requestCache, KeycloakOauth2UserService keycloakOidcUserService, Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> sessionAuthorizeRequestsCustomizer, Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> basicAuthorizeRequestsCustomizer, SecurityProperties securityProperties, List<BasicMatchersConfiguration> basicMatchersConfigurations, List<SessionMatchersConfiguration> sessionMatchersConfigurations) {
        this.logoutHandler = logoutHandler;
        this.requestCache = requestCache;
        this.keycloakOidcUserService = keycloakOidcUserService;
        this.sessionAuthorizeRequestsCustomizer = sessionAuthorizeRequestsCustomizer;
        this.basicAuthorizeRequestsCustomizer = basicAuthorizeRequestsCustomizer;
        this.securityProperties = securityProperties;
        this.basicMatchersConfigurations = basicMatchersConfigurations;
        this.sessionMatchersConfigurations = sessionMatchersConfigurations;
    }
}

