/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.config;

import digital.nedra.commons.starter.security.config.MatchersConfiguration;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientProperties;
import org.springframework.boot.autoconfigure.security.oauth2.client.OAuth2ClientPropertiesRegistrationAdapter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;

@Configuration
public class SecurityConfig {
    @Value(value="${spring.security.oauth2.client.registration.sso.provider}")
    private String oauth2Provider;

    @Bean
    public MatchersConfiguration swaggerMatchers() {
        ArrayList<String> antMatchers = new ArrayList<String>();
        antMatchers.add("/swagger-ui/**");
        String accessAttribute = "authenticated";
        return new MatchersConfiguration(antMatchers, accessAttribute);
    }

    @Bean
    @ConditionalOnMissingBean(value={JwtDecoder.class})
    public JwtDecoder keycloakJwtDecoder(OAuth2ClientProperties oauth2ClientProperties) {
        return NimbusJwtDecoder.withJwkSetUri((String)((OAuth2ClientProperties.Provider)oauth2ClientProperties.getProvider().get(this.oauth2Provider)).getJwkSetUri()).build();
    }

    @Bean
    @ConditionalOnMissingBean(value={OAuth2AuthorizedClientService.class})
    public OAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository(OAuth2ClientProperties properties) {
        ArrayList registrations = new ArrayList(OAuth2ClientPropertiesRegistrationAdapter.getClientRegistrations((OAuth2ClientProperties)properties).values());
        return new InMemoryClientRegistrationRepository(registrations);
    }
}

