/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.session.config;

import digital.nedra.commons.starter.common.config.properties.SecurityProperties;
import digital.nedra.commons.starter.keycloak.session.config.support.KeycloakLogoutHandler;
import digital.nedra.commons.starter.keycloak.session.config.support.KeycloakOauth2UserService;
import digital.nedra.commons.starter.keycloak.session.config.support.XhrCookieRequestCache;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.savedrequest.RequestCache;

@EnableGlobalMethodSecurity(prePostEnabled=true)
@Configuration
@EnableWebSecurity
public class SecurityConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    private final KeycloakLogoutHandler logoutHandler;
    private final XhrCookieRequestCache requestCache;
    private final KeycloakOauth2UserService keycloakOidcUserService;
    private final Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> authorizeRequestsCustomizer;
    private final SecurityProperties securityProperties;
    @Value(value="${spring.security.oauth2.client.registration.sso.provider}")
    private String oauth2Provider;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.authorizeRequests(this.authorizeRequestsCustomizer).oauth2Login(httpSec -> httpSec.loginPage("/oauth2/authorization/" + this.oauth2Provider).userInfoEndpoint().oidcUserService((OAuth2UserService)this.keycloakOidcUserService)).oauth2Client().and()).logout().addLogoutHandler((LogoutHandler)this.logoutHandler).and()).csrf().disable()).cors().and()).requestCache(i -> i.requestCache((RequestCache)this.requestCache));
    }

    public void configure(WebSecurity web) {
        WebSecurity.IgnoredRequestConfigurer ignoredRequestConfigurer = web.ignoring();
        this.securityProperties.getIgnoredUrls().forEach(xva$0 -> {
            WebSecurity.IgnoredRequestConfigurer cfr_ignored_0 = (WebSecurity.IgnoredRequestConfigurer)ignoredRequestConfigurer.antMatchers(new String[]{xva$0});
        });
    }

    public SecurityConfigurerAdapter(KeycloakLogoutHandler logoutHandler, XhrCookieRequestCache requestCache, KeycloakOauth2UserService keycloakOidcUserService, Customizer<ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry> authorizeRequestsCustomizer, SecurityProperties securityProperties) {
        this.logoutHandler = logoutHandler;
        this.requestCache = requestCache;
        this.keycloakOidcUserService = keycloakOidcUserService;
        this.authorizeRequestsCustomizer = authorizeRequestsCustomizer;
        this.securityProperties = securityProperties;
    }
}

