/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.keycloak.redis.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientId;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class RedisOAuth2AuthorizedClientService
implements OAuth2AuthorizedClientService {
    private static final Logger log = LoggerFactory.getLogger(RedisOAuth2AuthorizedClientService.class);
    private final RedisTemplate<Object, Object> authorizedClients;
    private final ClientRegistrationRepository clientRegistrationRepository;

    @Autowired
    public RedisOAuth2AuthorizedClientService(@Qualifier(value="redisTemplate") RedisTemplate<Object, Object> authorizedClients, ClientRegistrationRepository clientRegistrationRepository) {
        this.authorizedClients = authorizedClients;
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        ClientRegistration registration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
        if (registration == null) {
            return null;
        }
        OAuth2AuthorizedClientId oauth2AuthorizedClientId = new OAuth2AuthorizedClientId(clientRegistrationId, principalName);
        return (T)((OAuth2AuthorizedClient)this.authorizedClients.opsForHash().get((Object)oauth2AuthorizedClientId, (Object)oauth2AuthorizedClientId.hashCode()));
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal) {
        Assert.notNull((Object)authorizedClient, (String)"authorizedClient cannot be null");
        Assert.notNull((Object)principal, (String)"principal cannot be null");
        OAuth2AuthorizedClientId oauth2AuthorizedClientId = new OAuth2AuthorizedClientId(authorizedClient.getClientRegistration().getRegistrationId(), principal.getName());
        this.authorizedClients.opsForHash().put((Object)oauth2AuthorizedClientId, (Object)oauth2AuthorizedClientId.hashCode(), (Object)authorizedClient);
    }

    public void removeAuthorizedClient(String clientRegistrationId, String principalName) {
        Assert.hasText((String)clientRegistrationId, (String)"clientRegistrationId cannot be empty");
        Assert.hasText((String)principalName, (String)"principalName cannot be empty");
        ClientRegistration registration = this.clientRegistrationRepository.findByRegistrationId(clientRegistrationId);
        if (registration != null) {
            OAuth2AuthorizedClientId oauth2AuthorizedClientId = new OAuth2AuthorizedClientId(clientRegistrationId, principalName);
            this.authorizedClients.opsForHash().delete((Object)oauth2AuthorizedClientId, new Object[]{oauth2AuthorizedClientId.hashCode()});
        }
    }
}

