/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.audit.service;

import digital.nedra.commons.starter.audit.config.AuditProperties;
import digital.nedra.commons.starter.audit.dto.AuditEvent;
import digital.nedra.commons.starter.audit.dto.Extension;
import digital.nedra.commons.starter.audit.service.AuditLogger;
import digital.nedra.commons.starter.audit.service.AuditPropertiesResolver;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;

@Service
public class AuditService {
    private final AuditPropertiesResolver auditPropertiesResolver;
    private final AuditProperties auditProperties;
    private final AuditLogger auditLogger;

    public void logEvent(@NonNull AuditEvent event) {
        this.logEvent(event, null);
    }

    public void logEvent(@NonNull AuditEvent event, Extension extension) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        this.fillFromProps(values);
        this.fillFromEvent(event, values);
        values.put("extension", Optional.ofNullable(extension).map(this::buildExtension).orElse(""));
        StringSubstitutor substitutor = new StringSubstitutor(values);
        String result = substitutor.replace(this.auditProperties.getCef().getTemplate());
        this.auditLogger.logEvent(result);
    }

    private String buildExtension(Extension ext) {
        StringJoiner stringJoiner = new StringJoiner(" ", "", "|");
        this.addClearedValueIfPresent(stringJoiner, "src", ext.src());
        this.addClearedValueIfPresent(stringJoiner, "dst", ext.dst());
        this.addClearedValueIfPresent(stringJoiner, "shost", ext.shost());
        this.addClearedValueIfPresent(stringJoiner, "suid", ext.suid());
        this.addClearedValueIfPresent(stringJoiner, "suser", ext.suser());
        this.addClearedValueIfPresent(stringJoiner, "msg", ext.msg());
        Optional.ofNullable(ext.end()).ifPresent(s -> stringJoiner.add("end=" + this.buildEndTime((Long)s)));
        return stringJoiner.toString();
    }

    private void addClearedValueIfPresent(StringJoiner stringJoiner, String key, String value) {
        Optional.ofNullable(value).map(this::cleanUp).ifPresent(s -> stringJoiner.add(key + "=" + s));
    }

    private String buildEndTime(Long endTimeMillis) {
        AuditProperties.EndTime endTimeProperties = this.auditProperties.getEndTime();
        ZoneId zoneId = ZoneId.of(endTimeProperties.getTimeZone());
        ZonedDateTime endDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(endTimeMillis), zoneId);
        return Optional.ofNullable(endTimeProperties.getFormat()).map(DateTimeFormatter::ofPattern).map(endDateTime::format).orElseGet(() -> Long.toString(endDateTime.toInstant().toEpochMilli()));
    }

    private String cleanUp(String value) {
        return Optional.ofNullable(value).map(i -> i.replace("=", "")).map(i -> i.replace("|", "")).map(i -> i.replaceAll("[\\t\\n\\r]+", " ")).orElse(null);
    }

    private void fillFromEvent(AuditEvent event, Map<String, Object> values) {
        values.put("event.id", this.cleanUp(event.id()));
        values.put("event.name", this.cleanUp(event.name()));
        values.put("event.severity", event.severity().getValue());
    }

    private void fillFromProps(Map<String, Object> values) {
        values.put("cef.version", this.auditProperties.getCef().getVersion());
        values.put("company.name", this.cleanUp(this.auditProperties.getCompany().getName()));
        values.put("product.name", this.cleanUp(this.auditPropertiesResolver.getProductName().orElse("")));
        values.put("product.version", this.auditPropertiesResolver.getProductVersion().orElse(""));
    }

    public AuditService(AuditPropertiesResolver auditPropertiesResolver, AuditProperties auditProperties, AuditLogger auditLogger) {
        this.auditPropertiesResolver = auditPropertiesResolver;
        this.auditProperties = auditProperties;
        this.auditLogger = auditLogger;
    }
}

