/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.audit.dto;

/**
 * Набор дополнительных значений события аудита, определенных для поля Extension.
 *
 * @param src   IP адрес, полученный от клиента (например от browser).
 * @param dst   IP/Host адрес сервера на котором запущен сервис.
 * @param shost Host полученный от клиента (например от browser).
 * @param suid  При доменной аутентификации должен быть указать sid пользователя.
 *              При локальной аутентификации идентификатор системы.
 *              При аутентификации через IDP, то suid выгруженной записи.
 * @param suser При доменной аутентификации должна быть указана доменная УЗ,
 *              при локальной – локальная УЗ.
 * @param msg   Описание события в формате JSON или обычного текста.
 * @param end   Время фактического окончания события. Рекомендуется использовать Unix time в
 *              миллисекундах ({@link System#currentTimeMillis}).
 */
public record Extension(
    String src,
    String dst,
    String shost,
    String suid,
    String suser,
    String msg,
    Long end
) {
}
