/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.audit.dto;

import lombok.NonNull;

/**
 * Событие аудита.
 *
 * @param id       Идентификатор события.
 * @param name     Человеко-читаемое имя события. Имя события должно быть кратким и не должно
 *                 содержать избыточную информацию, которая представлена в других полях.
 * @param severity Важность события.
 */
public record AuditEvent(@NonNull String id, @NonNull String name, @NonNull Severity severity) {
}
