/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.audit;

import digital.nedra.commons.starter.audit.config.AuditProperties;
import digital.nedra.commons.starter.audit.service.AuditException;
import digital.nedra.commons.starter.audit.service.AuditPropertiesResolver;
import jakarta.annotation.PostConstruct;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ComponentScan
@PropertySource(value = "classpath:audit.properties", encoding = "UTF-8")
@EnableConfigurationProperties({AuditProperties.class})
@Slf4j
@RequiredArgsConstructor
public class AuditStarterConfiguration {
  private final AuditPropertiesResolver auditPropertiesResolver;

  @PostConstruct
  public void init() {
    checkProductProperties();
    log.info("Starter: audit-starter started");
  }

  private void checkProductProperties() {
    if (auditPropertiesResolver.getProductName().isEmpty()) {
      throw new AuditException("Ошибка конфигурации audit-starter: название приложения не задано. "
          + "Настроить название приложения можно несколькими способами:\n"
          + "1) В application.properties настроить параметр starters.audit.product.name;\n"
          + "2) Настроить BuildProperties (https://docs.spring.io/spring-boot/docs/current/"
          + "reference/htmlsingle/#howto.build.generate-info)");
    }
    if (auditPropertiesResolver.getProductVersion().isEmpty()) {
      throw new AuditException("Ошибка конфигурации audit-starter: версия приложения не задана. "
          + "Настроить версию приложения можно несколькими способами:\n"
          + "1) В application.properties настроить параметр starters.audit.product.version;\n"
          + "2) Настроить BuildProperties (https://docs.spring.io/spring-boot/docs/current/"
          + "reference/htmlsingle/#howto.build.generate-info)");
    }
  }
}
