/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.audit.service;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import java.nio.charset.StandardCharsets;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuditLogger {
  private static final Logger logger = initLogbackLogger();

  private static Logger initLogbackLogger() {
    LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();

    PatternLayoutEncoder encoder = new PatternLayoutEncoder();
    encoder.setPattern("%msg%n");
    encoder.setCharset(StandardCharsets.UTF_8);
    encoder.setContext(loggerContext);
    encoder.start();

    ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender<>();
    consoleAppender.setName("AUDIT-LOGGER-CONSOLE");
    consoleAppender.setEncoder(encoder);
    consoleAppender.setContext(loggerContext);
    consoleAppender.start();

    Logger logger = (Logger) LoggerFactory.getLogger(AuditLogger.class);
    logger.addAppender(consoleAppender);
    logger.setLevel(Level.INFO);
    logger.setAdditive(false);

    return logger;
  }

  public void logEvent(String result) {
    logger.info(result);
  }
}
