/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.audit.service;

import digital.nedra.commons.starter.audit.config.AuditProperties;
import java.util.Optional;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.info.BuildProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@RequiredArgsConstructor
public class AuditPropertiesResolver {
  private final Optional<BuildProperties> buildPropertiesOptional;
  private final AuditProperties auditProperties;

  public Optional<String> getProductName() {
    return Optional.ofNullable(auditProperties.getProduct().getName())
        .filter(StringUtils::hasLength)
        .or(() -> buildPropertiesOptional.map(BuildProperties::getName));
  }

  public Optional<String> getProductVersion() {
    return Optional.ofNullable(auditProperties.getProduct().getVersion())
        .filter(StringUtils::hasLength)
        .or(() -> buildPropertiesOptional.map(BuildProperties::getVersion));
  }
}
