/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.audit.dto;

import lombok.Value;
import org.springframework.lang.Nullable;

@Value
public class Extension {
  /**
   * IP адрес, полученный от клиента (например от browser).
   */
  @Nullable
  String src;
  /**
   * IP/Host адрес сервера на котором запущен сервис.
   */
  @Nullable
  String dst;
  /**
   * Host полученный от клиента (например от browser).
   */
  @Nullable
  String shost;
  /**
   * При доменной аутентификации должен быть указать sid пользователя.
   * При локальной аутентификации идентификатор системы.
   * При аутентификации через IDP, то suid выгруженной записи.
   */
  @Nullable
  String suid;
  /**
   * При доменной аутентификации должна быть указана доменная УЗ, при локальной – локальная УЗ.
   */
  @Nullable
  String suser;
  /**
   * Описание события. JSON, plain text
   */
  @Nullable
  String msg;
  /**
   * Время фактического окончания события. Рекомендуется использовать Unix time в миллисекундах.
   * System.currentTimeMillis();
   */
  @Nullable
  Long end;

}
