/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.audit.service;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import java.nio.charset.StandardCharsets;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuditLogger {
    private static final Logger logger = AuditLogger.initLogbackLogger();

    private static Logger initLogbackLogger() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern("%msg%n");
        encoder.setCharset(StandardCharsets.UTF_8);
        encoder.setContext((Context)loggerContext);
        encoder.start();
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setName("AUDIT-LOGGER-CONSOLE");
        consoleAppender.setEncoder((Encoder)encoder);
        consoleAppender.setContext((Context)loggerContext);
        consoleAppender.start();
        Logger logger = (Logger)LoggerFactory.getLogger(AuditLogger.class);
        logger.addAppender((Appender)consoleAppender);
        logger.setLevel(Level.INFO);
        logger.setAdditive(false);
        return logger;
    }

    public void logEvent(String result) {
        logger.info(result);
    }
}

