/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.audit.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "starters.audit")
@Data
public class AuditProperties {
  Cef cef = new Cef();
  Company company = new Company();
  Product product = new Product();
  EndTime endTime = new EndTime();

  @Data
  public static class Cef {
    /**
     * Шаблон ArcSight Common Event Format (CEF).
     */
    String template = "CEF:${cef.version}|${company.name}|${product.name}|${product.version}|"
        + "${event.id}|${event.name}|${event.severity}|${extension}";

    /**
     * Версия ArcSight Common Event Format (CEF).
     */
    Integer version = 0;
  }

  @Data
  public static class Company {
    /**
     * Название компании. Также можно установить через starters.company.name.
     */
    String name = "NEDRA";
  }

  @Data
  public static class Product {
    /**
     * Название приложения. Также можно установить через <code>starters.project.name</code>.
     * Если название приложения не задано, то значение берется из
     * <a href="https://docs.spring.io/spring-boot/docs/current/reference/htmlsingle/#howto.build.generate-info">BuildProperties</a>.
     */
    String name;

    /**
     * Версия приложения. Также можно установить через <code>starters.project.version</code>.
     * Если версия не задана, то значение берется из
     * <a href="https://docs.spring.io/spring-boot/docs/current/reference/htmlsingle/#howto.build.generate-info">BuildProperties</a>.
     */
    String version;
  }

  @Data
  public static class EndTime {
    /**
     * Формат времени окончания события. Если формат не задан, то время отображается в
     * миллисекундах, прошедших с 1 января 1970 года.
     */
    String format;

    /**
     * Часовой пояс времени окончания события.
     */
    String timeZone = "UTC";
  }
}
