/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.audit.service;

import digital.nedra.commons.starter.audit.config.AuditProperties;
import java.util.Optional;
import org.springframework.boot.info.BuildProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AuditPropertiesResolver {
    private final Optional<BuildProperties> buildPropertiesOptional;
    private final AuditProperties auditProperties;

    public Optional<String> getProductName() {
        return Optional.ofNullable(this.auditProperties.getProduct().getName()).filter(StringUtils::hasLength).or(() -> this.buildPropertiesOptional.map(BuildProperties::getName));
    }

    public Optional<String> getProductVersion() {
        return Optional.ofNullable(this.auditProperties.getProduct().getVersion()).filter(StringUtils::hasLength).or(() -> this.buildPropertiesOptional.map(BuildProperties::getVersion));
    }

    public AuditPropertiesResolver(Optional<BuildProperties> buildPropertiesOptional, AuditProperties auditProperties) {
        this.buildPropertiesOptional = buildPropertiesOptional;
        this.auditProperties = auditProperties;
    }
}

