/*
 * Decompiled with CFR 0.152.
 */
package digital.nedra.commons.starter.audit;

import digital.nedra.commons.starter.audit.config.AuditProperties;
import digital.nedra.commons.starter.audit.service.AuditException;
import digital.nedra.commons.starter.audit.service.AuditPropertiesResolver;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ComponentScan
@PropertySource(value={"classpath:audit.properties"}, encoding="UTF-8")
@EnableConfigurationProperties(value={AuditProperties.class})
public class AuditStarterConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AuditStarterConfiguration.class);
    private final AuditPropertiesResolver auditPropertiesResolver;

    @PostConstruct
    public void init() {
        this.checkProductProperties();
        log.info("Starter: audit-starter started");
    }

    private void checkProductProperties() {
        if (this.auditPropertiesResolver.getProductName().isEmpty()) {
            throw new AuditException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 audit-starter: \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e. \u041d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043c\u043e\u0436\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u043c\u0438 \u0441\u043f\u043e\u0441\u043e\u0431\u0430\u043c\u0438:\n1) \u0412 application.properties \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 starters.audit.product.name;\n2) \u041d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c BuildProperties (https://docs.spring.io/spring-boot/docs/current/reference/htmlsingle/#howto.build.generate-info)");
        }
        if (this.auditPropertiesResolver.getProductVersion().isEmpty()) {
            throw new AuditException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 audit-starter: \u0432\u0435\u0440\u0441\u0438\u044f \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043d\u0435 \u0437\u0430\u0434\u0430\u043d\u0430. \u041d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u0432\u0435\u0440\u0441\u0438\u044e \u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043c\u043e\u0436\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u0438\u043c\u0438 \u0441\u043f\u043e\u0441\u043e\u0431\u0430\u043c\u0438:\n1) \u0412 application.properties \u043d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 starters.audit.product.version;\n2) \u041d\u0430\u0441\u0442\u0440\u043e\u0438\u0442\u044c BuildProperties (https://docs.spring.io/spring-boot/docs/current/reference/htmlsingle/#howto.build.generate-info)");
        }
    }

    public AuditStarterConfiguration(AuditPropertiesResolver auditPropertiesResolver) {
        this.auditPropertiesResolver = auditPropertiesResolver;
    }
}

