/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.storage.s3;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import digital.ivan.lightchain.storage.config.ContextProperty;
import digital.ivan.lightchain.storage.config.IS3StorageProperty;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"lightchain.storage.s3.url"})
public class S3StorageAccessLayer {
    private final IS3StorageProperty storageProperties;
    private final AmazonS3 s3;

    public S3StorageAccessLayer(ContextProperty contextProperty) {
        this.storageProperties = contextProperty.getS3();
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.storageProperties.getAccessKey(), this.storageProperties.getSecretKey());
        this.s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.storageProperties.getUrl(), null))).withPathStyleAccessEnabled(Boolean.valueOf(true))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).build();
    }

    public void uploadFile(String keyName, String data) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_16);
        ByteArrayInputStream dataStream = new ByteArrayInputStream(bytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength((long)bytes.length);
        metadata.setLastModified(Date.from(Instant.now()));
        this.s3.putObject(new PutObjectRequest(this.storageProperties.getBucketName(), keyName, (InputStream)dataStream, metadata));
    }

    public List<String> listFiles(String keyPrefix, boolean filterLastDay) {
        ListObjectsV2Result result;
        ListObjectsV2Request request = new ListObjectsV2Request().withBucketName(this.storageProperties.getBucketName()).withPrefix(keyPrefix);
        ArrayList<String> allKeys = new ArrayList<String>();
        Date cutoffTime = Date.from(Instant.now().minus(24L, ChronoUnit.HOURS));
        do {
            result = this.s3.listObjectsV2(request);
            List keys = result.getObjectSummaries().stream().filter(object -> !filterLastDay || object.getLastModified().after(cutoffTime)).map(S3ObjectSummary::getKey).collect(Collectors.toList());
            allKeys.addAll(keys);
            String token = result.getNextContinuationToken();
            request.setContinuationToken(token);
        } while (result.isTruncated());
        return allKeys;
    }

    public String getFile(String keyName) {
        String string;
        S3Object object = this.s3.getObject(new GetObjectRequest(this.storageProperties.getBucketName(), keyName));
        S3ObjectInputStream objectContent = object.getObjectContent();
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)objectContent, StandardCharsets.UTF_16));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return string;
    }

    public void deleteFile(String keyName) {
        this.s3.deleteObject(this.storageProperties.getBucketName(), keyName);
    }
}

