/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.storage.s3;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import digital.ivan.lightchain.core.context.model.Message;
import digital.ivan.lightchain.storage.exception.MessageParsingException;
import digital.ivan.lightchain.storage.s3.S3StorageAccessLayer;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"lightchain.storage.s3.url"})
public class S3MessageHistoryStorage {
    private static final String FOLDER = "history";
    private final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private S3StorageAccessLayer s3StorageAccessLayer;

    public void saveMessage(Message message, String session) {
        try {
            this.s3StorageAccessLayer.uploadFile("history/" + session + "_" + System.currentTimeMillis(), this.mapper.writeValueAsString((Object)message));
        }
        catch (JsonProcessingException e) {
            throw new MessageParsingException((Exception)((Object)e));
        }
    }

    public List<Message> getMessages(String session) {
        return this.s3StorageAccessLayer.listFiles("history/" + session, true).stream().map(key -> {
            try {
                return (Message)this.mapper.readValue(this.s3StorageAccessLayer.getFile((String)key), Message.class);
            }
            catch (JsonProcessingException e) {
                throw new MessageParsingException((Exception)((Object)e));
            }
        }).collect(Collectors.toList());
    }
}

