/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.storage.redis;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import digital.ivan.lightchain.core.context.IMessageHistoryProvider;
import digital.ivan.lightchain.core.context.model.Message;
import digital.ivan.lightchain.storage.exception.RedisParsingException;
import digital.ivan.lightchain.storage.redis.RedisSessionStateStorageProvider;
import digital.ivan.lightchain.storage.s3.S3MessageHistoryStorage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(value={"spring.redis.host", "lightchain.storage.s3.url"})
public class RedisMessageStorageProvider
implements IMessageHistoryProvider {
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    private RedisSessionStateStorageProvider redisSessionStateStorageProvider;
    @Autowired
    private S3MessageHistoryStorage s3MessageHistoryStorage;
    @Value(value="${redis.history.prefix:HISTORY}")
    private String prefix;
    @Value(value="${redis.history.ttl:1}")
    private long ttl;
    @Autowired
    private StringRedisTemplate template;

    @Async
    public void saveMessage(Message message, String session) {
        try {
            this.template.opsForList().leftPush((Object)this.getKey(session), (Object)this.objectMapper.writeValueAsString((Object)message));
            this.template.expire((Object)this.getKey(session), Duration.ofHours(this.ttl));
            this.s3MessageHistoryStorage.saveMessage(message, session);
        }
        catch (JsonProcessingException e) {
            throw new RedisParsingException("Failed to serialize Message: " + message, e);
        }
    }

    public List<Message> getMessages(String session) {
        return this.getLimitMessages(session, -1);
    }

    public List<Message> getLimitMessages(String session, int limit) {
        ArrayList<Message> result = new ArrayList<Message>();
        for (String message : Objects.requireNonNull(this.template.opsForList().range((Object)this.getKey(session), 0L, (long)limit))) {
            try {
                result.add((Message)this.objectMapper.readValue(message, Message.class));
            }
            catch (JsonProcessingException e) {
                throw new RedisParsingException("Failed to serialize Message: " + message, e);
            }
        }
        return result;
    }

    private String getKey(String session) {
        return this.prefix + ":" + session;
    }
}

