/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.starter.vector;

import digital.ivan.lightchain.core.model.EmbedModel;
import digital.ivan.lightchain.starter.pinecone.PineconeClient;
import digital.ivan.lightchain.starter.pinecone.model.PineconeQuery;
import digital.ivan.lightchain.starter.vector.IVectorSearch;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class VectorSearchService
implements IVectorSearch {
    @Autowired
    private PineconeClient pineconeClient;
    @Autowired
    private EmbedModel embedModel;
    @Value(value="${pinecone.threshold:0.7}")
    private double threshold;

    @Override
    public List<String> search(String query) {
        List embeddings = this.embedModel.generate(query);
        return this.pineconeClient.query(new PineconeQuery(embeddings)).getMatches().stream().filter(match -> match.getScore() > this.threshold).map(match -> match.getMetadata().getInfo()).collect(Collectors.toList());
    }
}

