/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.starter.vector;

import digital.ivan.lightchain.core.model.EmbedModel;
import digital.ivan.lightchain.starter.openai.OpenAiClient;
import digital.ivan.lightchain.starter.openai.model.EmbeddingRequest;
import digital.ivan.lightchain.starter.openai.model.EmbeddingResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OpenAiEmbedModel
implements EmbedModel {
    @Autowired
    private OpenAiClient openAiClient;
    @Value(value="${openai.model.embed}")
    private String model;

    public List<Double> generate(String input) {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null.");
        }
        EmbeddingResponse embeddingResponse = this.openAiClient.getEmbedding(new EmbeddingRequest(input, this.model));
        return embeddingResponse.getData().stream().findFirst().map(EmbeddingResponse.EmbeddingData::getEmbedding).orElseThrow(() -> new RuntimeException("No embedding data available for the given input."));
    }
}

