/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.starter.pinecone;

import digital.ivan.lightchain.starter.pinecone.PineconeClient;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PineconeFeignClientConfig {
    @Value(value="${pinecone.api-key}")
    private String apiKey;
    @Value(value="${pinecone.url}")
    private String url;

    @Bean
    @ConditionalOnMissingBean
    public PineconeClient getFeignPinecone() {
        return (PineconeClient)Feign.builder().decoder((Decoder)new GsonDecoder()).encoder((Encoder)new GsonEncoder()).requestInterceptor(template -> template.header("Api-Key", new String[]{this.apiKey})).target(PineconeClient.class, this.url);
    }
}

