/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.starter.openai.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import digital.ivan.lightchain.starter.openai.model.MessageResponse;
import java.util.List;

public class CompletionResponse {
    private String id;
    private String object;
    private int created;
    private List<Choice> choices;
    private Usage usage;

    public CompletionResponse() {
    }

    public CompletionResponse(String id, String object, int created, List<Choice> choices, Usage usage) {
        this.id = id;
        this.object = object;
        this.created = created;
        this.choices = choices;
        this.usage = usage;
    }

    public String getId() {
        return this.id;
    }

    public String getObject() {
        return this.object;
    }

    public int getCreated() {
        return this.created;
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public Usage getUsage() {
        return this.usage;
    }

    public static class Usage {
        @JsonProperty(value="prompt_tokens")
        private int promptTokens;
        @JsonProperty(value="completion_tokens")
        private int completionTokens;
        @JsonProperty(value="total_tokens")
        private int totalTokens;

        public Usage() {
        }

        public Usage(int promptTokens, int completionTokens, int totalTokens) {
            this.promptTokens = promptTokens;
            this.completionTokens = completionTokens;
            this.totalTokens = totalTokens;
        }

        public int getPromptTokens() {
            return this.promptTokens;
        }

        public int getCompletionTokens() {
            return this.completionTokens;
        }

        public int getTotalTokens() {
            return this.totalTokens;
        }
    }

    public static class Choice {
        private int index;
        private MessageResponse message;
        @JsonProperty(value="finish_reason")
        private String finishReason;

        public Choice() {
        }

        public Choice(int index, MessageResponse message, String finishReason) {
            this.index = index;
            this.message = message;
            this.finishReason = finishReason;
        }

        public int getIndex() {
            return this.index;
        }

        public MessageResponse getMessage() {
            return this.message;
        }

        public String getFinishReason() {
            return this.finishReason;
        }
    }
}

