/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.starter.openai;

import digital.ivan.lightchain.starter.exeption.EnrichedWebClientResponseException;
import digital.ivan.lightchain.starter.openai.model.CompletionRequest;
import digital.ivan.lightchain.starter.openai.model.CompletionResponse;
import digital.ivan.lightchain.starter.openai.model.EmbeddingRequest;
import digital.ivan.lightchain.starter.openai.model.EmbeddingResponse;
import digital.ivan.lightchain.starter.openai.model.ModelsList;
import java.time.Duration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;

@Service
public class OpenAiClient {
    private final WebClient openAiWebClient;
    private final int timeout;

    public OpenAiClient(@Autowired WebClient openAiWebClient, @Value(value="${openai.client.timeout:10000}") int timeout) {
        this.openAiWebClient = openAiWebClient;
        this.timeout = timeout;
    }

    public ModelsList getModels() {
        return (ModelsList)this.openAiWebClient.get().uri("/v1/models", new Object[0]).retrieve().bodyToMono(ModelsList.class).block(Duration.ofMillis(this.timeout));
    }

    public CompletionResponse chatCompletions(CompletionRequest body) {
        return (CompletionResponse)((WebClient.RequestBodySpec)this.openAiWebClient.post().uri("/v1/chat/completions", new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)body).retrieve().bodyToMono(CompletionResponse.class).onErrorMap(WebClientResponseException.class, e -> new EnrichedWebClientResponseException(e.getMessage() + ", HTTP code: " + e.getRawStatusCode() + ", Body: " + e.getResponseBodyAsString())).block(Duration.ofMillis(this.timeout));
    }

    public EmbeddingResponse getEmbedding(EmbeddingRequest body) {
        return (EmbeddingResponse)((WebClient.RequestBodySpec)this.openAiWebClient.post().uri("/v1/embeddings", new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)body).retrieve().bodyToMono(EmbeddingResponse.class).onErrorMap(WebClientResponseException.class, e -> new EnrichedWebClientResponseException(e.getMessage() + ", HTTP code: " + e.getRawStatusCode() + ", Body: " + e.getResponseBodyAsString())).block(Duration.ofMillis(this.timeout));
    }
}

