/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.starter.config;

import digital.ivan.lightchain.core.exception.NoRouteAvailableException;
import digital.ivan.lightchain.core.router.IRouterConfig;
import digital.ivan.lightchain.core.router.IRouterToolCall;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RouterConfig
implements IRouterConfig {
    private Map<String, IRouterToolCall> toolsMap;
    private String description;
    private String tools;

    @Autowired
    void setTools(List<IRouterToolCall> tools) {
        this.toolsMap = tools.stream().collect(Collectors.toMap(tool -> tool.getDescription().getName(), Function.identity()));
        this.description = tools.stream().map(tool -> tool.getDescription().getName() + ":" + tool.getDescription().getDescription()).collect(Collectors.joining("\n"));
        this.tools = tools.stream().map(tool -> tool.getDescription().getName()).collect(Collectors.joining(","));
    }

    public IRouterToolCall mapRoute(String name) {
        if (!this.toolsMap.containsKey(name)) {
            throw new NoRouteAvailableException("No route for \"" + name + "\" is available.");
        }
        return this.toolsMap.get(name);
    }

    public String getDescription() {
        return this.description;
    }

    public String getStringToolsList() {
        return this.tools;
    }

    public List<IRouterToolCall> getToolsList() {
        return new ArrayList<IRouterToolCall>(this.toolsMap.values());
    }
}

