/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.starter.chat;

import digital.ivan.lightchain.core.model.ILLModel;
import digital.ivan.lightchain.core.model.LLMInput;
import digital.ivan.lightchain.core.model.LLMOutput;
import digital.ivan.lightchain.starter.openai.OpenAiClient;
import digital.ivan.lightchain.starter.openai.model.CompletionRequest;
import digital.ivan.lightchain.starter.openai.model.Message;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OpenAiChatModel
implements ILLModel<String, String> {
    @Autowired
    private OpenAiClient openAiClient;
    @Value(value="${openai.model.chat}")
    private String model;
    @Value(value="${openai.temperature:0.1}")
    private double temperature;

    public List<LLMOutput<String>> generate(LLMInput<String> input) {
        return this.openAiClient.chatCompletions(new CompletionRequest(this.model, this.temperature, List.of(new Message("user", (String)input.getValue())))).getChoices().stream().map(choice -> new LLMOutput((Object)choice.getMessage().getContent(), (float)choice.getIndex())).collect(Collectors.toList());
    }
}

