/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.starter.chat;

import digital.ivan.lightchain.core.model.ILLModel;
import digital.ivan.lightchain.core.model.LLMInput;
import digital.ivan.lightchain.core.model.LLMOutput;
import digital.ivan.lightchain.core.model.func.LLMInputFunc;
import digital.ivan.lightchain.core.router.ToolCall;
import digital.ivan.lightchain.starter.openai.OpenAiClient;
import digital.ivan.lightchain.starter.openai.model.CompletionRequest;
import digital.ivan.lightchain.starter.openai.model.Message;
import digital.ivan.lightchain.starter.openai.model.MessageResponse;
import digital.ivan.lightchain.starter.tools.HumanRouterTool;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OpenAiChatFuncModel
implements ILLModel<ToolCall, LLMInputFunc> {
    @Autowired
    private OpenAiClient openAiClient;
    @Autowired
    private HumanRouterTool humanRouterTool;
    @Value(value="${openai.model.chat}")
    private String model;
    @Value(value="${openai.temperature:0.1}")
    private double temperature;

    public List<LLMOutput<ToolCall>> generate(LLMInput<LLMInputFunc> input) {
        List<Message> context = ((LLMInputFunc)input.getValue()).getContext().stream().map(msg -> new Message(msg.getType(), msg.getValue())).collect(Collectors.toList());
        context.add(new Message("user", ((LLMInputFunc)input.getValue()).getInput()));
        CompletionRequest request = new CompletionRequest(this.model, this.temperature, context, ((LLMInputFunc)input.getValue()).getTools());
        return this.openAiClient.chatCompletions(request).getChoices().stream().map(choice -> new LLMOutput((Object)this.processFunc(choice.getMessage()), (float)choice.getIndex())).collect(Collectors.toList());
    }

    private ToolCall processFunc(MessageResponse message) {
        if (message.getFunctionCall() != null) {
            JSONObject arguments = new JSONObject(message.getFunctionCall().getArguments());
            String argumentStr = arguments.keySet().stream().map(arg_0 -> ((JSONObject)arguments).getString(arg_0)).collect(Collectors.joining(","));
            return new ToolCall(message.getFunctionCall().getName(), argumentStr);
        }
        return new ToolCall(this.humanRouterTool.getDescription().getName(), message.getContent());
    }
}

