/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.starter.chat;

import digital.ivan.lightchain.core.chain.impl.SimpleChatChain;
import digital.ivan.lightchain.core.context.IMessageHistoryProvider;
import digital.ivan.lightchain.core.context.ISessionStateProvider;
import digital.ivan.lightchain.core.context.model.ChatState;
import digital.ivan.lightchain.core.context.model.Message;
import digital.ivan.lightchain.core.context.model.SessionState;
import digital.ivan.lightchain.core.exception.OutputProcessingException;
import digital.ivan.lightchain.core.prompt.KeyConsts;
import digital.ivan.lightchain.core.router.IRouterConfig;
import digital.ivan.lightchain.core.router.IRouterToolCall;
import digital.ivan.lightchain.core.router.ToolCall;
import digital.ivan.lightchain.starter.chat.AgentRoutedChainService;
import digital.ivan.lightchain.starter.chat.IChatService;
import digital.ivan.lightchain.starter.tools.HumanRouterTool;
import digital.ivan.lightchain.starter.tools.VectorSearchTool;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(value={IChatService.class})
public class AgentRoutedWithHistoryService
implements IChatService {
    public static final int CHAT_HISTORY_LIMIT = 4;
    private static final String ASSISTANT = "assistant";
    private static final String USER = "user";
    @Autowired
    private AgentRoutedChainService routedChain;
    @Autowired
    private SimpleChatChain simpleChatChain;
    @Autowired
    private IRouterConfig routerConfig;
    @Autowired
    private IMessageHistoryProvider messageHistoryProvider;
    @Autowired
    private ISessionStateProvider sessionStateProvider;

    @Override
    @Async
    public void sendUserInput(String input, String session, long utc, Logger logger) {
        SessionState state = this.sessionStateProvider.getSessionState(session);
        this.messageHistoryProvider.saveMessage(new Message(USER, input, utc), session);
        if (state.getChatState() == ChatState.WAITING_FOR_HUMAN) {
            this.updateChatStateAndSaveMessage(ChatState.ACTIVE, session, state, new Message(ASSISTANT, this.runChatChain(input, this.fetchChatContext(session, null), session), System.currentTimeMillis()));
        } else {
            ToolCall call = this.routedChain.runRoutedChain(input, logger, session);
            IRouterToolCall tool = this.routerConfig.mapRoute(call.getToolName());
            if (tool instanceof HumanRouterTool) {
                this.updateChatStateAndSaveMessage(ChatState.WAITING_FOR_HUMAN, session, state, new Message(ASSISTANT, call.getArgument(), System.currentTimeMillis()));
            } else if (tool instanceof VectorSearchTool) {
                this.updateChatStateAndSaveMessage(ChatState.ACTIVE, session, state, new Message(ASSISTANT, this.runChatChain(input, this.fetchChatContext(session, tool.call(call.getArgument())), session), System.currentTimeMillis()));
            } else {
                throw new OutputProcessingException("Returned tool is not supported. Name: " + call.getToolName() + ", argument: " + call.getArgument());
            }
        }
    }

    private void updateChatStateAndSaveMessage(ChatState chatState, String session, SessionState state, Message message) {
        state.setChatState(chatState);
        this.sessionStateProvider.setSessionState(session, state);
        this.messageHistoryProvider.saveMessage(message, session);
    }

    private String fetchChatContext(String session, String context) {
        String result = "Chat history: " + this.messageHistoryProvider.getLimitMessages(session, 4).stream().map(msg -> msg.getType() + ":" + msg.getValue()).collect(Collectors.joining("\n"));
        if (context != null) {
            result = result + "\nSearch results:\n" + context;
        }
        return result;
    }

    private String runChatChain(String input, String context, String session) {
        return (String)this.simpleChatChain.run(new HashMap<String, String>(Map.of(KeyConsts.INPUT.name(), input, KeyConsts.CONTEXT.name(), context)), session).getValue();
    }
}

