/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.starter.chat;

import digital.ivan.lightchain.core.chain.impl.AgentRoutedChain;
import digital.ivan.lightchain.core.chain.impl.AgentRoutedFuncChain;
import digital.ivan.lightchain.core.context.IMessageHistoryProvider;
import digital.ivan.lightchain.core.model.func.LLMInputFunc;
import digital.ivan.lightchain.core.prompt.KeyConsts;
import digital.ivan.lightchain.core.router.IRouterConfig;
import digital.ivan.lightchain.core.router.ToolCall;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AgentRoutedChainService {
    @Value(value="${lightchain.agentrouted.func}")
    private Boolean funcRouter;
    @Autowired(required=false)
    private AgentRoutedChain agentRoutedChain;
    @Autowired(required=false)
    private AgentRoutedFuncChain agentRoutedFuncChain;
    @Autowired
    private IMessageHistoryProvider messageHistoryProvider;
    @Autowired
    private IRouterConfig routerConfig;

    public ToolCall runRoutedChain(String inputStr, Logger logger, String session) {
        if (!this.funcRouter.booleanValue()) {
            return (ToolCall)this.agentRoutedChain.run(new HashMap<String, CallSite>(Map.of(KeyConsts.INPUT.name(), inputStr, KeyConsts.CONTEXT.name(), "Chat history: " + this.messageHistoryProvider.getLimitMessages(session, 4).stream().map(msg -> msg.getType() + ":" + msg.getValue()).collect(Collectors.joining("\n")))), logger).getValue();
        }
        LLMInputFunc input = new LLMInputFunc(inputStr, this.messageHistoryProvider.getLimitMessages(session, 4), this.routerConfig.getToolsList());
        return (ToolCall)this.agentRoutedFuncChain.run(input, logger).getValue();
    }
}

