/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.core.prompt;

import digital.ivan.lightchain.core.exception.InputParamsNotValidException;
import digital.ivan.lightchain.core.prompt.IPromptTemplateProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class SimplePromptBuilder {
    private List<Function<Map<String, String>, String>> parts;
    private IPromptTemplateProvider templateProvider;

    public SimplePromptBuilder(IPromptTemplateProvider templateProvider) {
        this.templateProvider = templateProvider;
        this.parts = new ArrayList<Function<Map<String, String>, String>>();
        Matcher m = Pattern.compile("\\{(.*?)}|([^{}]+)").matcher(templateProvider.getPrompt());
        HashSet<String> keySet = new HashSet<String>();
        while (m.find()) {
            if (m.group(1) != null) {
                String key = m.group(1);
                if (!keySet.add(key)) {
                    throw new IllegalArgumentException("Duplicate key found in template: " + key);
                }
                this.parts.add(keys -> this.retrieveFromKeys((Map<String, String>)keys, key));
                continue;
            }
            String str = m.group(2);
            this.parts.add(keys -> str);
        }
    }

    public String build(Map<String, String> keys) throws InputParamsNotValidException {
        this.templateProvider.validate(keys);
        String result = this.parts.stream().map(part -> (String)part.apply(keys)).collect(Collectors.joining());
        return result;
    }

    private String retrieveFromKeys(Map<String, String> keys, String key) {
        if (keys.containsKey(key)) {
            return keys.get(key);
        }
        throw new IllegalArgumentException("Required key missing: " + key);
    }
}

