/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.core.parser;

import digital.ivan.lightchain.core.exception.OutputProcessingException;
import digital.ivan.lightchain.core.parser.IOutputParser;
import digital.ivan.lightchain.core.router.ToolCall;

public class SimpleAgentRoutedParser
implements IOutputParser {
    public static final String THOUGHT = "Thought:";
    public static final String ACTION = "Action:";
    public static final String ACTION_INPUT = "Action Input:";

    @Override
    public ToolCall parse(String output) throws OutputProcessingException {
        if (!output.startsWith(THOUGHT) && output.indexOf(ACTION) != 1 && output.indexOf(ACTION_INPUT) != 1) {
            throw new OutputProcessingException("Invalid output format. Output:" + output);
        }
        String outputWithoutAction = output.substring(output.indexOf(ACTION) + ACTION.length());
        String[] splitOutput = outputWithoutAction.split(ACTION_INPUT);
        if (splitOutput.length != 2) {
            throw new OutputProcessingException("Invalid output format. Expected action and action input. Output:" + output);
        }
        String toolName = splitOutput[0].trim();
        String toolInput = splitOutput[1].trim();
        return new ToolCall(toolName, toolInput);
    }
}

