/*
 * Decompiled with CFR 0.152.
 */
package digital.ivan.lightchain.core.chain.impl;

import digital.ivan.lightchain.core.chain.ISyncSessionChain;
import digital.ivan.lightchain.core.chain.prompt.ChatWithContextPromptTemplateProvider;
import digital.ivan.lightchain.core.exception.OutputProcessingException;
import digital.ivan.lightchain.core.model.ILLModel;
import digital.ivan.lightchain.core.model.LLMInput;
import digital.ivan.lightchain.core.model.LLMOutput;
import digital.ivan.lightchain.core.prompt.SimplePromptBuilder;
import java.util.Comparator;
import java.util.Map;

public class SimpleChatChain
implements ISyncSessionChain<String> {
    private final ILLModel<String, String> model;
    private final SimplePromptBuilder promptBuilder;

    public SimpleChatChain(ILLModel<String, String> model) {
        this.model = model;
        this.promptBuilder = new SimplePromptBuilder(new ChatWithContextPromptTemplateProvider());
    }

    @Override
    public LLMOutput<String> run(Map<String, String> params, String session) throws OutputProcessingException {
        LLMInput<String> input = new LLMInput<String>(this.promptBuilder.build(params));
        return this.model.generate(input).stream().max(Comparator.comparingDouble(LLMOutput::getProbability)).orElseThrow(() -> new OutputProcessingException("No result output of LLM"));
    }
}

